//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, Single axis move example
// Contents: 
//     Trapezoidal ӵ带 Ͽ (+) 30000 ̵ 
//	 ٽ (-) 30000 ̵ϴ Դϴ. 
//	   Ÿ ӵ   Ư  ʰ 
//	 Ÿ ӵ  ⺻ Pulses PPS  մϴ. 
// Remarks:
//    α׷ COMI-LX501  Դϴ. 
//*********************************************************************
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

#define X_AXIS	0
void main()
{
	if(!COMILX_LoadDll())
		exit(-1); // Load Dll Failure
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE)
		exit(-1); // Load Device Failure

	COMILX_MC_Reset(hDevice);
	
	// ӵ   //
	COMILX_MC_SetSpeedMode(hDevice, X_AXIS, 1); 
	COMILX_MC_SetSpeed(hDevice, X_AXIS, 0, 10000); 
	COMILX_MC_SetAccel(hDevice, X_AXIS, 20000, 20000);
	
	printf("Press any key to start move\n");
	getch();
	printf("Start to move 30000(pulses)...\n");
	// (+) 30000 Pulse ̵  //
	COMILX_MC_StartMove(hDevice, X_AXIS, 30000);
	while(!COMILX_MC_Done (hDevice, X_AXIS))
		printf("Command Position = %.0f\n", COMILX_MC_GetPosition_C(hDevice, X_AXIS));
	printf("Complete moving 30000(pulses)\n"); 
	
	printf("Press any key to move (-)30000(pulses)\n");
	getch();
	printf("Start to move (-)30000 ...\n");
	// (-) 30000 Pulse ̵  //
	COMILX_MC_StartMove(hDevice, X_AXIS, -30000);
	while(!COMILX_MC_Done (hDevice, X_AXIS))
		printf("Command Position = %.0f\n", COMILX_MC_GetPosition_C(hDevice, X_AXIS));
	printf("Complete moving (-)30000(pulses) ...\n");
	printf("Press any key to exit program");
	getch();
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}